<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Admin: enqueue media, color picker, and scripts
 */
function cleanlite_uc_admin_assets( $hook ) {
    if ( 'settings_page_cleanlite-uc-settings' !== $hook ) {
        return;
    }

    wp_enqueue_media();
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_script( 'wp-color-picker' );

    wp_enqueue_script(
        'cleanlite-uc-admin-js',
        CLEANLITE_UC_URL . 'assets/js/uc-admin.js',
        array( 'jquery', 'wp-color-picker' ),
        CLEANLITE_UC_VERSION,
        true
    );

    wp_localize_script( 'cleanlite-uc-admin-js', 'cleanliteUcAdmin', array(
        'selectImage' => __( 'Select or upload image', 'cleanlite-under-construction-countdown' ),
    ) );
}
add_action( 'admin_enqueue_scripts', 'cleanlite_uc_admin_assets' );

/**
 * Settings Page Menu
 */
function cleanlite_uc_admin_menu() {
    add_options_page(
        __( 'CleanLite Under Construction', 'cleanlite-under-construction-countdown' ),
        __( 'Under Construction', 'cleanlite-under-construction-countdown' ),
        'manage_options',
        'cleanlite-uc-settings',
        'cleanlite_uc_settings_page'
    );
}
add_action( 'admin_menu', 'cleanlite_uc_admin_menu' );

/**
 * Sanitization Callbacks
 */
function cleanlite_uc_sanitize_checkbox( $value ) {
    return $value ? '1' : '0';
}
function cleanlite_uc_sanitize_html( $value ) {
    return wp_kses_post( $value );
}
function cleanlite_uc_sanitize_hex( $color ) {
    return sanitize_hex_color( $color );
}

/**
 * Register Settings
 */
function cleanlite_uc_register_settings() {
    $group = 'cleanlite_uc_group';

    // General
    register_setting( $group, 'cleanlite_uc_enabled', array( 'sanitize_callback' => 'cleanlite_uc_sanitize_checkbox' ) );
    register_setting( $group, 'cleanlite_uc_logo', array( 'sanitize_callback' => 'esc_url_raw' ) );
    register_setting( $group, 'cleanlite_uc_headline', array( 'sanitize_callback' => 'sanitize_text_field' ) );
    register_setting( $group, 'cleanlite_uc_description', array( 'sanitize_callback' => 'cleanlite_uc_sanitize_html' ) );
    register_setting( $group, 'cleanlite_uc_bg', array( 'sanitize_callback' => 'esc_url_raw' ) );

    // Design & Colors
    register_setting( $group, 'cleanlite_uc_font_family', array( 'sanitize_callback' => 'sanitize_text_field' ) );
    register_setting( $group, 'cleanlite_uc_color_heading', array( 'sanitize_callback' => 'cleanlite_uc_sanitize_hex' ) );
    register_setting( $group, 'cleanlite_uc_color_text', array( 'sanitize_callback' => 'cleanlite_uc_sanitize_hex' ) );
    register_setting( $group, 'cleanlite_uc_color_timer', array( 'sanitize_callback' => 'cleanlite_uc_sanitize_hex' ) );
    register_setting( $group, 'cleanlite_uc_color_overlay', array( 'sanitize_callback' => 'cleanlite_uc_sanitize_hex' ) );
    register_setting( $group, 'cleanlite_uc_overlay_opacity', array( 'sanitize_callback' => 'absint' ) ); // 0-100
    register_setting( $group, 'cleanlite_uc_timer_style', array( 'sanitize_callback' => 'sanitize_text_field' ) );

    // Countdown & Labels
    register_setting( $group, 'cleanlite_uc_countdown_enabled', array( 'sanitize_callback' => 'cleanlite_uc_sanitize_checkbox' ) );
    register_setting( $group, 'cleanlite_uc_countdown_datetime', array( 'sanitize_callback' => 'sanitize_text_field' ) );
    register_setting( $group, 'cleanlite_uc_label_days', array( 'sanitize_callback' => 'sanitize_text_field' ) );
    register_setting( $group, 'cleanlite_uc_label_hours', array( 'sanitize_callback' => 'sanitize_text_field' ) );
    register_setting( $group, 'cleanlite_uc_label_minutes', array( 'sanitize_callback' => 'sanitize_text_field' ) );
    register_setting( $group, 'cleanlite_uc_label_seconds', array( 'sanitize_callback' => 'sanitize_text_field' ) );

    // Socials & Status
    register_setting( $group, 'cleanlite_uc_social_facebook', array( 'sanitize_callback' => 'esc_url_raw' ) );
    register_setting( $group, 'cleanlite_uc_social_twitter', array( 'sanitize_callback' => 'esc_url_raw' ) );
    register_setting( $group, 'cleanlite_uc_social_instagram', array( 'sanitize_callback' => 'esc_url_raw' ) );
    register_setting( $group, 'cleanlite_uc_status_code', array( 'sanitize_callback' => 'sanitize_text_field' ) );
}
add_action( 'admin_init', 'cleanlite_uc_register_settings' );

/**
 * Settings Page HTML
 */
function cleanlite_uc_settings_page() {
    if ( ! current_user_can( 'manage_options' ) ) {
        return;
    }

    $default_date = current_datetime()->modify( '+1 week' )->format( 'Y-m-d\TH:i' );

    $defaults = array(
        'cleanlite_uc_enabled'            => '1',
        'cleanlite_uc_logo'               => '',
        'cleanlite_uc_headline'           => __( 'We are coming soon', 'cleanlite-under-construction-countdown' ),
        'cleanlite_uc_description'        => __( 'Our website is under construction. Check back soon.', 'cleanlite-under-construction-countdown' ),
        'cleanlite_uc_bg'                 => '',
        'cleanlite_uc_font_family'        => 'sans',
        'cleanlite_uc_color_heading'      => '#222222',
        'cleanlite_uc_color_text'         => '#555555',
        'cleanlite_uc_color_timer'        => '#333333',
        'cleanlite_uc_color_overlay'      => '#ffffff',
        'cleanlite_uc_overlay_opacity'    => '95',
        'cleanlite_uc_timer_style'        => 'minimal',
        'cleanlite_uc_countdown_enabled'  => '1',
        'cleanlite_uc_countdown_datetime' => $default_date,
        'cleanlite_uc_label_days'         => __( 'Days', 'cleanlite-under-construction-countdown' ),
        'cleanlite_uc_label_hours'        => __( 'Hours', 'cleanlite-under-construction-countdown' ),
        'cleanlite_uc_label_minutes'      => __( 'Minutes', 'cleanlite-under-construction-countdown' ),
        'cleanlite_uc_label_seconds'      => __( 'Seconds', 'cleanlite-under-construction-countdown' ),
        'cleanlite_uc_social_facebook'    => '',
        'cleanlite_uc_social_twitter'     => '',
        'cleanlite_uc_social_instagram'   => '',
        'cleanlite_uc_status_code'        => '503',
    );

    $options = array();
    foreach ( $defaults as $key => $val ) {
        $options[ $key ] = get_option( $key, $val );
    }
    ?>
    <div class="wrap">
      <h1><?php esc_html_e( 'CleanLite Under Construction Settings', 'cleanlite-under-construction-countdown' ); ?></h1>
      <form method="post" action="options.php">
        <?php settings_fields( 'cleanlite_uc_group' ); ?>
        
        <h2 class="title"><?php esc_html_e( 'General Settings', 'cleanlite-under-construction-countdown' ); ?></h2>
        <table class="form-table" role="presentation">
            <tr>
              <th scope="row"><?php esc_html_e( 'Enable Mode', 'cleanlite-under-construction-countdown' ); ?></th>
              <td>
                <label>
                  <input type="checkbox" name="cleanlite_uc_enabled" value="1" <?php checked( $options['cleanlite_uc_enabled'], '1' ); ?>>
                  <?php esc_html_e( 'Activate maintenance page', 'cleanlite-under-construction-countdown' ); ?>
                </label>
              </td>
            </tr>
            <tr>
              <th scope="row"><?php esc_html_e( 'Logo', 'cleanlite-under-construction-countdown' ); ?></th>
              <td>
                <input id="cleanlite_uc_logo" type="text" name="cleanlite_uc_logo" value="<?php echo esc_attr( $options['cleanlite_uc_logo'] ); ?>" class="regular-text">
                <input id="cleanlite_uc_logo_button" class="button" type="button" value="<?php esc_attr_e( 'Upload Image', 'cleanlite-under-construction-countdown' ); ?>">
              </td>
            </tr>
            <tr>
              <th scope="row"><?php esc_html_e( 'Headline', 'cleanlite-under-construction-countdown' ); ?></th>
              <td><input type="text" name="cleanlite_uc_headline" value="<?php echo esc_attr( $options['cleanlite_uc_headline'] ); ?>" class="regular-text"></td>
            </tr>
            <tr>
              <th scope="row"><?php esc_html_e( 'Description', 'cleanlite-under-construction-countdown' ); ?></th>
              <td><textarea name="cleanlite_uc_description" rows="4" class="large-text"><?php echo esc_textarea( $options['cleanlite_uc_description'] ); ?></textarea></td>
            </tr>
            <tr>
              <th scope="row"><?php esc_html_e( 'Background Image', 'cleanlite-under-construction-countdown' ); ?></th>
              <td>
                <input id="cleanlite_uc_bg" type="text" name="cleanlite_uc_bg" value="<?php echo esc_attr( $options['cleanlite_uc_bg'] ); ?>" class="regular-text">
                <input id="cleanlite_uc_bg_button" class="button" type="button" value="<?php esc_attr_e( 'Upload Image', 'cleanlite-under-construction-countdown' ); ?>">
              </td>
            </tr>
        </table>

        <hr>

        <h2 class="title"><?php esc_html_e( 'Design & Colors', 'cleanlite-under-construction-countdown' ); ?></h2>
        <table class="form-table">
            <tr>
                <th scope="row"><?php esc_html_e( 'Font Family', 'cleanlite-under-construction-countdown' ); ?></th>
                <td>
                    <select name="cleanlite_uc_font_family">
                        <option value="sans" <?php selected($options['cleanlite_uc_font_family'], 'sans'); ?>>System Sans-Serif (Modern)</option>
                        <option value="serif" <?php selected($options['cleanlite_uc_font_family'], 'serif'); ?>>Serif (Elegant)</option>
                        <option value="mono" <?php selected($options['cleanlite_uc_font_family'], 'mono'); ?>>Monospace (Tech)</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php esc_html_e( 'Heading Color', 'cleanlite-under-construction-countdown' ); ?></th>
                <td><input type="text" name="cleanlite_uc_color_heading" value="<?php echo esc_attr( $options['cleanlite_uc_color_heading'] ); ?>" class="my-color-field" data-default-color="#222222"></td>
            </tr>
            <tr>
                <th scope="row"><?php esc_html_e( 'Description Color', 'cleanlite-under-construction-countdown' ); ?></th>
                <td><input type="text" name="cleanlite_uc_color_text" value="<?php echo esc_attr( $options['cleanlite_uc_color_text'] ); ?>" class="my-color-field" data-default-color="#555555"></td>
            </tr>
            <tr>
                <th scope="row"><?php esc_html_e( 'Timer Color', 'cleanlite-under-construction-countdown' ); ?></th>
                <td><input type="text" name="cleanlite_uc_color_timer" value="<?php echo esc_attr( $options['cleanlite_uc_color_timer'] ); ?>" class="my-color-field" data-default-color="#333333"></td>
            </tr>
            <tr>
                <th scope="row"><?php esc_html_e( 'Overlay Color', 'cleanlite-under-construction-countdown' ); ?></th>
                <td>
                    <input type="text" name="cleanlite_uc_color_overlay" value="<?php echo esc_attr( $options['cleanlite_uc_color_overlay'] ); ?>" class="my-color-field" data-default-color="#ffffff">
                </td>
            </tr>
            <tr>
                <th scope="row"><?php esc_html_e( 'Overlay Opacity (%)', 'cleanlite-under-construction-countdown' ); ?></th>
                <td>
                    <input type="number" name="cleanlite_uc_overlay_opacity" value="<?php echo esc_attr( $options['cleanlite_uc_overlay_opacity'] ); ?>" min="0" max="100" step="1">
                </td>
            </tr>
            <tr>
                <th scope="row"><?php esc_html_e( 'Timer Style', 'cleanlite-under-construction-countdown' ); ?></th>
                <td>
                    <select name="cleanlite_uc_timer_style">
                        <option value="minimal" <?php selected($options['cleanlite_uc_timer_style'], 'minimal'); ?>>Minimal (Text only)</option>
                        <option value="boxed" <?php selected($options['cleanlite_uc_timer_style'], 'boxed'); ?>>Boxed (Background on numbers)</option>
                    </select>
                </td>
            </tr>
        </table>

        <hr>

        <h2 class="title"><?php esc_html_e( 'Countdown & Labels', 'cleanlite-under-construction-countdown' ); ?></h2>
        <table class="form-table">
            <tr>
                <th scope="row"><?php esc_html_e( 'Target Date/Time', 'cleanlite-under-construction-countdown' ); ?></th>
                <td>
                    <label><input type="checkbox" name="cleanlite_uc_countdown_enabled" value="1" <?php checked( $options['cleanlite_uc_countdown_enabled'], '1' ); ?>> <?php esc_html_e('Enable', 'cleanlite-under-construction-countdown'); ?></label><br><br>
                    <input type="datetime-local" name="cleanlite_uc_countdown_datetime" value="<?php echo esc_attr( $options['cleanlite_uc_countdown_datetime'] ); ?>">
                </td>
            </tr>
            <tr>
                <th scope="row"><?php esc_html_e( 'Labels (Translate)', 'cleanlite-under-construction-countdown' ); ?></th>
                <td>
                    <input type="text" name="cleanlite_uc_label_days" value="<?php echo esc_attr( $options['cleanlite_uc_label_days'] ); ?>" placeholder="Days" size="10">
                    <input type="text" name="cleanlite_uc_label_hours" value="<?php echo esc_attr( $options['cleanlite_uc_label_hours'] ); ?>" placeholder="Hours" size="10">
                    <input type="text" name="cleanlite_uc_label_minutes" value="<?php echo esc_attr( $options['cleanlite_uc_label_minutes'] ); ?>" placeholder="Minutes" size="10">
                    <input type="text" name="cleanlite_uc_label_seconds" value="<?php echo esc_attr( $options['cleanlite_uc_label_seconds'] ); ?>" placeholder="Seconds" size="10">
                </td>
            </tr>
        </table>

        <hr>

        <h2 class="title"><?php esc_html_e( 'Social & Advanced', 'cleanlite-under-construction-countdown' ); ?></h2>
        <table class="form-table">
            <tr>
              <th scope="row"><?php esc_html_e( 'Social Links', 'cleanlite-under-construction-countdown' ); ?></th>
              <td>
                <input type="url" name="cleanlite_uc_social_facebook" placeholder="Facebook URL" class="regular-text" value="<?php echo esc_attr( $options['cleanlite_uc_social_facebook'] ); ?>"><br>
                <input type="url" name="cleanlite_uc_social_twitter" placeholder="X / Twitter URL" class="regular-text" value="<?php echo esc_attr( $options['cleanlite_uc_social_twitter'] ); ?>"><br>
                <input type="url" name="cleanlite_uc_social_instagram" placeholder="Instagram URL" class="regular-text" value="<?php echo esc_attr( $options['cleanlite_uc_social_instagram'] ); ?>">
              </td>
            </tr>
            <tr>
              <th scope="row"><?php esc_html_e( 'HTTP Status', 'cleanlite-under-construction-countdown' ); ?></th>
              <td>
                <select name="cleanlite_uc_status_code">
                  <option value="503" <?php selected( $options['cleanlite_uc_status_code'], '503' ); ?>>503 Service Unavailable</option>
                  <option value="200" <?php selected( $options['cleanlite_uc_status_code'], '200' ); ?>>200 OK</option>
                </select>
              </td>
            </tr>
        </table>

        <?php submit_button(); ?>
      </form>
    </div>
    <?php
}