(function () {
  if ( typeof cleanliteUcData === 'undefined' || ! cleanliteUcData.enabled ) return;

  var target = parseInt(cleanliteUcData.target, 10);
  if ( isNaN(target) ) return;

  var labels = cleanliteUcData.labels || { days:'Days', hours:'Hours', minutes:'Minutes', seconds:'Seconds' };

  function pad(n) { return (n < 10 ? '0' : '') + n; }

  function render(diff) {
    var el = document.getElementById('cl-uc-timer');
    if (!el) return;

    if (diff <= 0) {
      el.innerHTML = '<div class="cl-uc-num" style="font-size:1.5rem; color:inherit;">We are live!</div>';
      return;
    }

    var total = Math.floor(diff / 1000);
    var days = Math.floor(total / 86400);
    var hours = Math.floor((total % 86400) / 3600);
    var mins = Math.floor((total % 3600) / 60);
    var secs = Math.floor(total % 60);

    var html = '';
    var units = [
        { l: labels.days, v: days },
        { l: labels.hours, v: pad(hours) },
        { l: labels.minutes, v: pad(mins) },
        { l: labels.seconds, v: pad(secs) }
    ];

    units.forEach(function(u){
        html += '<div class="cl-uc-time-unit">';
        html += '<span class="cl-uc-num">' + u.v + '</span>';
        html += '<span class="cl-uc-label">' + u.l + '</span>';
        html += '</div>';
    });

    el.innerHTML = html;
  }

  function tick() {
    var now = Date.now();
    var diff = target - now;
    render(diff);
    if ( diff <= 0 ) clearInterval(intervalId);
  }

  tick();
  var intervalId = setInterval(tick, 1000);
})();